<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class RemovePaymentMethodRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'payment_method_id' => [
                'required',
                'string',
                'regex:/^pm_[a-zA-Z0-9]+$/',
            ],
        ];
    }

    public function messages(): array
    {
        return [
            'payment_method_id.required' => 'El ID del método de pago es obligatorio.',
            'payment_method_id.string' => 'El ID debe ser una cadena de texto.',
            'payment_method_id.regex' => 'El ID del método de pago no es válido.',
        ];
    }
}
