<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SetDefaultPaymentMethodRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'stripe_customer_id' => ['required', 'string'],
            'payment_method_id' => ['required', 'string', 'regex:/^pm_[a-zA-Z0-9]+$/'],
        ];
    }

    public function messages(): array
    {
        return [
            'stripe_customer_id.required' => 'El cliente es obligatorio.',
            'payment_method_id.required' => 'El método de pago es obligatorio.',
            'payment_method_id.regex' => 'El método de pago debe tener el formato correcto (pm_xxx).',
        ];
    }
}
