<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateProductWithPricesRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'product_name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'features' => 'nullable|array',
            'features.*.nameFeature' => 'required|string|max:255',
            'features.*.enabled' => 'required|boolean',
            'max_menus' => 'nullable|integer|min:0',
            'max_products' => 'nullable|integer|min:0',
            'is_active' => 'required|boolean',
        ];
    }

    public function messages(): array
    {
        return [
            'product_name.required' => 'El nombre del plan es obligatorio.',
            'features.*.nameFeature.required' => 'El nombre de la característica es obligatorio.',
            'features.*.enabled.required' => 'El estado de la característica es obligatorio.',
            'max_menus.integer' => 'El número máximo de menús debe ser un número entero.',
            'max_products.integer' => 'El número máximo de productos debe ser un número entero.',
            'is_active.required' => 'El estado del plan es obligatorio.',
            'is_active.boolean' => 'El estado del plan debe ser verdadero o falso.'
        ];
    }
}
