<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Article extends Model
{
    use HasFactory;

    protected $primaryKey = 'article_id';

    public $timestamps = false;

    protected $fillable = [
        'name',
        'description',
        'price',
        'image_url',
        'label_unit',
        'price_unit',
        'price_special',
        'category_id',
    ];

    public function getImageUrlAttribute($value)
    {
        if (!$value) {
            return null;
        }
        return asset($value);
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }
}