<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Menu extends Model
{
    use HasFactory;

    protected $primaryKey = 'menu_id';
    protected $fillable = [
        'type_background',
        'background_url',
        'color_background',
        'color_nav',
        'color_text',
        'img_main_url',
        'restaurant_id'
    ];

    public function restaurant()
    {
        return $this->belongsTo(Restaurant::class, 'restaurant_id');
    }

    public function categories()
    {
        return $this->hasMany(Category::class, 'menu_id')->whereNull('parent_id');
    }

    public function getBackgroundUrlAttribute($value)
    {
        if (!$value) {
            return null;
        }
        return asset($value);
    }

    public function getImgMainUrlAttribute($value)
    {
        if (!$value) {
            return null;
        }
        return asset($value);
    }
}