<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Support\Str;

class Restaurant extends Model
{
    use HasFactory;

    protected $primaryKey = 'restaurant_id';
    protected $fillable = [
        'name',
        'slug',
        'address',
        'logo_url',
        'user_id'
    ];

    /**
     * Get the menustep associated with the restaurant.
     */
    public function menustep(): HasOne
    {
        return $this->hasOne(MenuStep::class, 'restaurant_id', 'restaurant_id');
    }

    public function getLogoUrlAttribute($value)
    {
        if (!$value) {
            return null;
        }
        return asset($value);
    }
}
