<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SubscriptionPlan extends Model
{
    use HasFactory;

    protected $primaryKey = 'plan_id';

    protected $fillable = [
        'name',
        'description',
        'stripe_product_id',
        'features',
        'max_menus',
        'max_products',
        'is_active',
    ];

    protected $casts = [
        'features' => 'array',
    ];

    public function prices()
    {
        return $this->hasMany(SubscriptionPrice::class, 'plan_id');
    }
}