<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SubscriptionPrice extends Model
{
    use HasFactory;

    public $timestamps = false;

    protected $primaryKey = 'price_subscription_id';

    protected $fillable = [
        'stripe_price_id',
        'price',
        'currency',
        'interval',
        'order',
        'is_active',
        'plan_id',
    ];

    public function plan()
    {
        return $this->belongsTo(SubscriptionPlan::class, 'plan_id');
    }
}
