<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('menus', function (Blueprint $table) {
            $table->increments('menu_id');
            $table->string('type_background')->nullable();
            $table->string('background_url')->nullable();
            $table->string('img_main_url')->nullable();
            $table->string('color_background')->nullable();
            $table->string('color_nav')->nullable();
            $table->string('color_text')->nullable();
            $table->timestamps();
            
            $table->integer('restaurant_id')->unsigned();
            $table->foreign('restaurant_id')->references('restaurant_id')->on('restaurants')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('menus');
    }
};
