<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subscription_plans', function (Blueprint $table) {
            $table->increments('plan_id');
            $table->string('name', 400);
            $table->mediumText('description')->nullable();
            $table->string('stripe_product_id')->unique();
            $table->json('features')->nullable();
            $table->integer('max_menus')->default(0);
            $table->integer('max_products')->default(0);
            $table->boolean('is_active')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscription_plans');
    }
};
