<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subscription_prices', function (Blueprint $table) {
            $table->increments('price_subscription_id');
            $table->string('stripe_price_id')->unique();
            $table->decimal('price', 10, 2)->unsigned();
            $table->string('currency', 10)->default('mxn');
            $table->string('interval', 20)->default('month');
            $table->integer('order')->default(0);
            $table->boolean('is_active')->default(true);
            $table->integer('plan_id')->unsigned();
            $table->foreign('plan_id')->references('plan_id')->on('subscription_plans')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscription_prices');
    }
};
