<?php

namespace Database\Seeders;

use App\Models\Role;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $roleAdmin = Role::create(['name' => 'admin']);
        Role::create(['name' => 'owner']);

        User::create([
            'name' => 'Administrador',
            'email' => 'canalla.agency@gmail.com',
            'password' => Hash::make('@#AdminDev2024#'),
            'role_id' => $roleAdmin->role_id,
            'email_verified_at' => now()
        ]);
    }
}