<?php

use App\Http\Controllers\Api\Auth\AuthController;
use App\Http\Controllers\Api\Auth\EmailVerificationController;
use App\Http\Controllers\Api\Auth\ForgotPasswordController;
use App\Http\Controllers\Api\Auth\PasswordController;
use App\Http\Controllers\Api\Auth\ResetPasswordController;
use App\Http\Controllers\Api\Auth\UserOwnerController;
use App\Http\Controllers\Api\Payments\StripeController;
use App\Http\Controllers\Api\Restaurant\ArticleController;
use App\Http\Controllers\Api\Restaurant\CategoryController;
use App\Http\Controllers\Api\Restaurant\MenuController;
use App\Http\Controllers\Api\Restaurant\RestaurantController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::prefix("auth")->group(function () {
    Route::post("register", [AuthController::class, "createUser"]);
    Route::post("login", [AuthController::class, "authenticate"]);
    Route::post("logout", [AuthController::class, "logout"]);
});

Route::post('forgot-password', [ForgotPasswordController::class, 'sendResetLinkEmail']);
Route::post('reset-password', [ResetPasswordController::class, 'reset']);
Route::get('/email/verify/{id}/{token}', [EmailVerificationController::class, 'verify']);
Route::post('/email/resend', [EmailVerificationController::class, 'resend']);

Route::prefix("restaurants")->group(function () {
    Route::get("all-restaurants/{idUser}", [RestaurantController::class, "allRestaurants"])->middleware('auth:sanctum');
    Route::get("detail-restaurant/{slug}", [RestaurantController::class, "detailRestaurant"])->middleware('auth:sanctum');
    Route::get("detail-menu/{slug}", [RestaurantController::class, "getMenuDetail"])->middleware('auth:sanctum');
    Route::post("create-information", [RestaurantController::class, "createInformation"])->middleware('auth:sanctum');
    Route::post("update-information", [RestaurantController::class, "updateInformation"])->middleware('auth:sanctum');
    Route::put("update-step", [RestaurantController::class, "updateStep"])->middleware('auth:sanctum');
    Route::delete('delete-restaurant/{idRestaurant}', [RestaurantController::class, "deleteRestaurant"])->middleware('auth:sanctum');
});

Route::prefix("categories")->group(function () {
    Route::get("all-category/{idMenu}", [CategoryController::class, "getAllCategory"])->middleware('auth:sanctum');
    Route::get("detail-category/{idCategory}", [CategoryController::class, "getCategoryDetail"])->middleware('auth:sanctum');
    Route::post("create-category", [CategoryController::class, "createCategory"])->middleware('auth:sanctum');
    Route::post("update-category", [CategoryController::class, "updateCategory"])->middleware('auth:sanctum');
    Route::delete('delete-category/{idCategory}', [CategoryController::class, "deleteCategory"])->middleware('auth:sanctum');
});

Route::prefix("articles")->group(function () {
    Route::get("detail-article/{idArticle}", [ArticleController::class, "getArticleDetail"])->middleware('auth:sanctum');
    Route::post("create-article", [ArticleController::class, "createArticle"])->middleware('auth:sanctum');
    Route::post("update-article", [ArticleController::class, "updateArticle"])->middleware('auth:sanctum');
    Route::delete('delete-article/{idArticle}', [ArticleController::class, "deleteArticle"])->middleware('auth:sanctum');
});

Route::prefix("menus")->group(function () {
    Route::get("get-menu/{slugRestaurant}", [MenuController::class, "getMenuAll"]);
    Route::post("update-information", [MenuController::class, "updateInformationMenu"])->middleware('auth:sanctum');
});

Route::prefix("users")->group(function () {
    Route::get("get-users-owners", [UserOwnerController::class, "getUsersOwners"]);
});

Route::prefix("profile")->group(function () {
    Route::post("change-password", [PasswordController::class, "changePassword"])->middleware('auth:sanctum');
});

Route::prefix("payments")->group(function () {
    Route::get("get-setup-intent", [StripeController::class, "getSetupIntent"])->middleware('auth:sanctum');
    Route::get("get-methods-payment/{idCustomer}", [StripeController::class, "getCustomerPaymentMethods"])->middleware('auth:sanctum');
    
    Route::post("create-customer", [StripeController::class, "createCustomer"])->middleware('auth:sanctum');
    Route::post("set-default-payment", [StripeController::class, "setDefaultPaymentMethod"])->middleware('auth:sanctum');
    Route::delete("delete-method-payment", [StripeController::class, "removePaymentMethod"])->middleware('auth:sanctum');
});

Route::prefix("plans")->group(function () {
    Route::get("get-plans", [StripeController::class, "getPlanSuscription"]);
    Route::get("get-plan-detail/{planId}", [StripeController::class, "getPlanDetail"])->middleware('auth:sanctum');
    Route::post("create-plan", [StripeController::class, "createProductWithPrice"])->middleware('auth:sanctum');
    Route::put("update-plan/{idPlan}", [StripeController::class, "updateProductWithPrice"])->middleware('auth:sanctum');
    Route::delete("delete-plan/{idPlan}", [StripeController::class, "deletePlan"])->middleware('auth:sanctum');
});