<?php

namespace App\Channels;

use App\Interfaces\NotificationChannel;
use App\Mail\WeddingInvitation;
use App\Models\Guest;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;

class EmailChannel implements NotificationChannel
{
    public function send(Guest $guest): bool
    {
        try {
            $messageText = 'Nos encantaría que nos acompañaras en este día tan especial.';
            $url = route('home', ['guest' => $guest->slug]);

            Mail::to($guest->email)->send(new WeddingInvitation($guest, $messageText, $url));
            Log::info("Email enviado con éxito a: {$guest->name}");
            return true;
        } catch (\Exception $e) {
            Log::error("Error enviando Email a {$guest->name}: " . $e->getMessage());
            return false;
        }
    }
}