<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\RsvpService;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function __construct(protected RsvpService $rsvpService)
    {
    }

    public function index()
    {
        $user = Auth::user();
        $numberConfirm = null;
        if ($user->hasAnyRole(['organizer'])) {
            $numberConfirm = $this->rsvpService->getCountConfirmation();
        }
        return view('admin.dashboard', compact('numberConfirm'));
    }
}
