<?php

namespace App\Http\Controllers;

use App\Services\EventService;
use App\Services\GuestService;
use Illuminate\Http\Request;
use Illuminate\View\View;

class HomeController extends Controller
{
    public function __construct(protected EventService $eventService, protected GuestService $guestService)
    {
    }

    public function index(Request $request): View
    {
        $guestData = null;
        $guestName = $request->input('guest');
        if (!empty(($guestName))) {
            $guestData = $this->guestService->findBySlug($guestName);
        }
        $event = $this->eventService->get();
        $dietaryOptions = [
            'ninguna' => 'Ninguna',
            'vegetariano' => 'Vegetariano',
            'vegano' => 'Vegano',
            'celiaco' => 'Sin gluten (celíaco)',
            'lactosa' => 'Intolerancia a la lactosa',
            'frutos-secos' => 'Alergia a frutos secos',
            'mariscos' => 'Alergia a mariscos',
            'huevo' => 'Alergia al huevo',
            'soya' => 'Alergia a la soya',
            'otra' => 'Otra'
        ];
        // dd($event);
        return view("home", compact("event", "guestData", 'dietaryOptions'));
    }
}
