@props([
    'idParent' => null,
    'label' => '',
    'name' => '',
    'options' => [],
    'selected' => null,
    'placeholder' => 'Seleccione una opción',
])

@php
    // Resolver valor seleccionado: primero old(), luego prop selected
    $value = old($name, $selected);

    // Construir lista final de opciones
    $items = $options;

    // Si el placeholder todavía no existe, lo añadimos al principio
    if (!array_key_exists('', $items)) {
        $items = ['' => $placeholder] + $items;
    }
@endphp

<label {{ $attributes->merge(['class' => 'select-main']) }} @if($idParent) id="{{ $idParent }}" @endif>
    @if ($label)
        <p class="label">
            {{ $label }}
        </p>
    @endif
    <div class="relative">
        <select
            name="{{ $name }}"
            class="selected-input"
        >
            @foreach ($items as $optValue => $optLabel)
                <option
                    value="{{ $optValue }}"
                    @selected($value === (string) $optValue)
                >
                    {{ $optLabel }}
                </option>
            @endforeach
        </select>
        <div class="pointer-events-none absolute right-2 top-1/2 -translate-y-1/2">
            <x-icons.arrows-down />
        </div>
    </div>

    @error($name)
        <span class="text-red-500 text-sm mt-2 block">{{ $message }}</span>
    @enderror
</label>