<?php
use App\Http\Controllers\Organizer\EventController;
use App\Http\Controllers\Organizer\GuestController;
use App\Http\Controllers\Organizer\NotificationController;
use App\Http\Controllers\Organizer\RsvpController;
use Illuminate\Support\Facades\Route;


Route::prefix('organizer')
    ->name('organizer.')
    ->middleware(['auth', 'role:organizer'])
    ->group(function () {
        Route::prefix('guests')->name('guests.')->group(function () {
            Route::get('/', [GuestController::class, 'index'])->name('index');
            Route::get('/create', [GuestController::class, 'create'])->name('create');
            Route::get('/{id}/edit', [GuestController::class, 'edit'])->name('edit');
            Route::get('/{id}', [GuestController::class, 'show'])->name('show');

            Route::post('/', [GuestController::class, 'store'])->name('store');
            Route::put('/{id}', [GuestController::class, 'update'])->name('update');
            Route::delete('/{id}', [GuestController::class, 'destroy'])->name('destroy');
        });

        Route::prefix('event')->name('event.')->group(function () {
            Route::get('/edit', [EventController::class, 'edit'])->name('edit');
            Route::put('/update', [EventController::class, 'update'])->name('update');
        });

        Route::prefix('rsvps')->name('rsvps.')->group(function () {
            Route::get('/', [RsvpController::class, 'index'])->name('index');
            Route::post('/send-reminder', [RsvpController::class, 'sendReminder'])->name('sendReminder');
        });

        Route::prefix('notifications')->name('notifications.')->group(function () {
            Route::get('/', [NotificationController::class, 'index'])->name('index');
        });
    });