<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps([
    'start_date' => '',
    'end_date' => '', 
    'location' => '',
]) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps([
    'start_date' => '',
    'end_date' => '', 
    'location' => '',
]); ?>
<?php foreach (array_filter(([
    'start_date' => '',
    'end_date' => '', 
    'location' => '',
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<?php
    use Illuminate\Support\Carbon;

    $start = $start_date ? Carbon::parse($start_date)->locale('es') : null;
    $end = $end_date ? Carbon::parse($end_date)->locale('es') : null;
?>

<div class="bg-primary300 py-16 md:py-20 lg:py-36">
    <div class="container">
        <div class="container-center">
            <div id="card-w-animated" class="flex flex-col md:flex-row z-30 relative w-full">
                <div class="md:flex-1">
                    <div class="bg-white rounded-3xl relative">
                        <div class="flex flex-col px-8 sm:px-10 md:px-12 lg:px-16 py-8 md:py-10 lg:py-12">
                            <p class="font-mono text-size-small-heading text-complement300 mb-6">Fecha</p>

                            <?php if($start): ?>
                                <p class="font-mono text-size-small-heading text-complement300 mb-6">
                                    <?php echo e(ucfirst($start->translatedFormat('l d \d\e F, Y'))); ?>

                                </p>
                                <p class="font-mono text-size-small-heading text-complement300 mb-6">
                                    <?php echo e($start->translatedFormat('g:i A')); ?>

                                </p>
                            <?php endif; ?>

                            <?php if($end): ?>
                                <p class="font-mono text-size-small-heading text-complement300 mb-6">
                                    a <?php echo e($end->translatedFormat('g:i A')); ?>

                                </p>
                            <?php endif; ?>
                            <?php if($location): ?>
                                <p class="font-mono text-size-small-heading text-complement300 mb-6">Ubicación</p>
                                <p class="font-mono text-size-small-heading text-complement300"><?php echo e($location); ?></p>
                            <?php endif; ?>
                        </div>
                        <div class="bg-primary100 py-4 rounded-b-3xl px-8 sm:px-10 md:px-12 lg:px-16">
                            <p class="font-main text-complement300">WEDDING PASS</p>
                        </div>
                        <div class="hidden md:block absolute top-1/2 -translate-y-1/2 right-0 h-[90%] border-dashed border-r-2 border-r-complement300">
                        </div>
                    </div>
                </div>
                <div class="md:shrink-0 md:w-[320px]">
                    <div class="bg-white rounded-3xl w-full px-8 sm:px-10 h-full py-8 md:py-10 lg:py-12">
                        <div class="mb-6">
                            <?php if (isset($component)) { $__componentOriginal33ecad46e67f698426fa1bc8fc84db4a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal33ecad46e67f698426fa1bc8fc84db4a = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.icons.plane','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('icons.plane'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal33ecad46e67f698426fa1bc8fc84db4a)): ?>
<?php $attributes = $__attributesOriginal33ecad46e67f698426fa1bc8fc84db4a; ?>
<?php unset($__attributesOriginal33ecad46e67f698426fa1bc8fc84db4a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal33ecad46e67f698426fa1bc8fc84db4a)): ?>
<?php $component = $__componentOriginal33ecad46e67f698426fa1bc8fc84db4a; ?>
<?php unset($__componentOriginal33ecad46e67f698426fa1bc8fc84db4a); ?>
<?php endif; ?>
                        </div>
                        <p class="font-mono text-size-small-heading text-complement300 mb-6">Código de vestimenta</p>
                        <p class="font-mono text-size-small-heading text-complement300 mb-6">Formal</p>
                        <?php if (isset($component)) { $__componentOriginal8565cc6e3559fc0755ba5bce504752a5 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8565cc6e3559fc0755ba5bce504752a5 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.controls.button','data' => ['variant' => 'main']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('controls.button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'main']); ?>Ver ubicación en el mapa <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8565cc6e3559fc0755ba5bce504752a5)): ?>
<?php $attributes = $__attributesOriginal8565cc6e3559fc0755ba5bce504752a5; ?>
<?php unset($__attributesOriginal8565cc6e3559fc0755ba5bce504752a5); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8565cc6e3559fc0755ba5bce504752a5)): ?>
<?php $component = $__componentOriginal8565cc6e3559fc0755ba5bce504752a5; ?>
<?php unset($__componentOriginal8565cc6e3559fc0755ba5bce504752a5); ?>
<?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH C:\laragon\webodorrio\resources\views/components/infoaddress.blade.php ENDPATH**/ ?>