@props([
    'href' => null,
    'type' => 'button',
    'variant' => 'primary',
])

@php
    // Paleta por variante
    $palette = [
        'main'   => 'btn-main',
        'primary'   => 'btn-primary',
        'secondary' => 'btn-secondary',
        'optional' => 'btn-optional',
        'add' => 'btn-add',
        'remove' => 'btn-remove'
    ][$variant] ?? '';
@endphp


@if ($href)
    <a href="{{ $href }}"
       {{ $attributes->merge(['class' => "btn parrafo $palette"]) }}>
        <span class="truncate">{{ $slot }}</span>
    </a>
@else
    <button type="{{ $type }}"
            {{ $attributes->merge(['class' => "btn parrafo $palette"]) }}>
        <span class="truncate">{{ $slot }}</span>
    </button>
@endif