<?php

namespace App\Http\Controllers\Organizer;


use App\DTOs\Guest\UpdateEventDTO;
use App\Http\Controllers\Controller;
use App\Http\Requests\Organizer\UpdateEventRequest;
use App\Services\EventService;
use Illuminate\Http\RedirectResponse;
use Illuminate\View\View;

class EventController extends Controller
{
    public function __construct(protected EventService $eventService)
    {
    }

    public function edit(): View
    {
        $event = $this->eventService->get();
        // dd($event);
        return view('organizer.event.edit', compact('event'));
    }

    public function update(UpdateEventRequest $request): RedirectResponse
    {
        $dto = new UpdateEventDTO($request->validated());
        $eventResponse = $this->eventService->upsert($dto);
        if($eventResponse === null){
            return redirect()->back()->with('error', 'Lo sentimos no pudimos actualizar los detalles del evento.');
        }
        return redirect()->back()->with('success', 'Detalles del evento actualizados correctamente.');
    }
}
