<?php

namespace App\Http\Requests\Organizer;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateGuestRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $guestId = $this->route('id');
        return [
            'name' => ['required', 'string', 'max:255'],
            'phone' => ['required', 'string', 'regex:/^\+52\d{10}$/'],
            'email' => [
                'nullable',
                'email',
                'max:255',
                Rule::unique('guests', 'email')->ignore($guestId),
            ],
            'max_guests' => ['required', 'integer', 'min:0'],
        ];
    }

    public function messages(): array
    {
        return [
            'name.required' => 'El nombre es obligatorio.',
            'name.string' => 'El nombre debe ser un texto.',
            'name.max' => 'El nombre no debe exceder los :max caracteres.',

            'phone.required' => 'El teléfono es obligatorio.',
            'phone.string' => 'El teléfono debe ser un texto.',
            'phone.regex' => 'El número debe comenzar con +52 y tener 10 dígitos (ej. +522221234567).',

            'email.email' => 'El correo electrónico no es válido.',
            'email.max' => 'El correo electrónico no debe exceder los :max caracteres.',
            'email.unique' => 'Este correo electrónico ya está registrado.',

            'max_guests.required' => 'El número máximo de invitados es obligatorio.',
            'max_guests.integer' => 'El número máximo de invitados debe ser un número entero.',
            'max_guests.min' => 'El número máximo de invitados no puede ser negativo.',
        ];
    }
}