<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreRsvpRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }
    public function rules(): array
    {
        return [
            'slug' => 'required|string|exists:guests,slug',
            'name' => 'required|string|max:255',
            'asistencia' => 'required|in:yes,no',
            'guest_count' => 'required_if:asistencia,yes|nullable|integer|min:1',
            'dietary_restrictions' => 'nullable|string|max:255',
            'comments' => 'nullable|string|max:1000',
        ];
    }

    public function messages(): array
    {
        return [
            'slug.required' => 'El identificador del invitado es obligatorio.',
            'slug.exists' => 'El invitado no fue encontrado.',

            'name.required' => 'El nombre es obligatorio.',
            'name.string' => 'El nombre debe ser una cadena de texto.',
            'name.max' => 'El nombre no puede tener más de 255 caracteres.',

            'asistencia.required' => 'Debes confirmar si asistirás o no.',
            'asistencia.in' => 'El valor de asistencia debe ser "si" o "no".',

            'guest_count.required' => 'Debes indicar cuántas personas asistirán contigo.',
            'guest_count.integer' => 'El número de asistentes debe ser un número entero.',
            'guest_count.min' => 'Debe asistir al menos una persona.',

            'dietary_restrictions.string' => 'Las restricciones alimentarias deben ser texto.',
            'dietary_restrictions.max' => 'Las restricciones alimentarias no pueden tener más de 255 caracteres.',

            'comments.string' => 'Los comentarios deben ser texto.',
            'comments.max' => 'Los comentarios no pueden tener más de 1000 caracteres.',
        ];
    }
}