<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Guest extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'email',
        'phone',
        'max_guests',
        'uuid'
    ];

    public function rsvp()
    {
        return $this->hasOne(Rsvp::class);
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($guest) {
            $base = $guest->name ?? 'anonimo';

            $slug = Str::slug($base);
            $originalSlug = $slug;
            $i = 1;
            while (static::where('slug', $slug)->exists()) {
                $slug = $originalSlug . '-' . $i++;
            }
            $guest->slug = $slug;
        });
    }

    /**
     * Obtiene el número de teléfono listo para ser usado por WhatsApp/Twilio.
     */
    public function getWhatsappNumber(): string
    {
        return $this->phone;
    }
}