<?php

namespace App\Services;

use App\Models\User;
use Exception;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\Log;
class UserService
{

    public function getUserByRole($role, int $perPage = 10): LengthAwarePaginator
    {
        return User::whereHas("roles", function ($query) use ($role) {
            $query->where("name", $role);
        })->paginate($perPage);
    }

    public function getUserById($id): ?User
    {
        try {
            $user = User::find($id);
            return $user ?? null;
        } catch (Exception $e) {
            Log::error('No se pudo encontrar el usuario: ' . $e->getMessage(), [
                'data' => $id,
                'trace' => $e->getTraceAsString(),
            ]);
            return null;
        }
    }

    public function delete(int $id): bool
    {
        try {
            $user = User::find($id);
            return $user ? $user->delete() : false;
        } catch (Exception $e) {
            Log::error('Error al elimnar el usuario: ' . $e->getMessage(), [
                'data' => $id,
                'trace' => $e->getTraceAsString(),
            ]);
            return false;
        }
    }
}