<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rsvps', function (Blueprint $table) {
            $table->id();
            $table->enum('attendance', ['yes', 'no'])->nullable(); // Asistirá o no
            $table->string('dietary_restrictions')->nullable();   // Restricciones alimentarias
            $table->text('comments')->nullable();                 // Mensaje o felicitación
            $table->timestamp('confirmed_at')->nullable();        // Fecha de confirmación
            $table->timestamps();
            $table->foreignId('guest_id')->constrained()->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rsvps');
    }
};