@php
$columns = [
    [
        'label' => 'Nombre',
        'width' => '400px',
        'render' => fn($guest) => e($guest->name),
    ],
    [
        'label' => 'Correo',
        'width' => '400px',
        'render' => fn($guest) => e($guest->email),
    ],
    [
        'label' => 'Teléfono',
        'width' => '400px',
        'render' => fn($guest) => e($guest->phone),
    ],
    [
        'label' => 'Acciones',
        'width' => '240px',
        'render' => fn($guest) => '<a href="' . route('organizer.guests.show', $guest->id) . '" class="hover:underline font-bold">Ver detalle</a>',
    ],
];
@endphp

<x-layouts.auth-layout>
    <div class="flex flex-col max-w-[960px]">
        <div class="flex flex-wrap justify-between gap-3 py-4">
            <h2 class="text-complement300 font-roboto text-size-subtitle font-medium">Invitados</h2>
            <x-controls.button href="{{ route('organizer.guests.create') }}" variant="primary">
                Añadir invitado
            </x-controls.button>
        </div>
        <div class="py-3">
            <x-tables.table-with-pagination :columns="$columns" :items="$guests" />
        </div>
    </div>
</x-layouts.auth-layout>