<?php
use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\Guest\RsvpController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\Organizer\GuestController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Organizer\NotificationController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get("/", [HomeController::class, "index"])->name("home");
Route::middleware('guest')->group(function () {
    Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
});
Route::post('/login', [AuthController::class, 'login'])->name('login.perform');
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

Route::post('/rsvp', [RsvpController::class, 'store'])->name('rsvp.store');

Route::post('/organizer/notifications/send', [NotificationController::class, 'sendNotifications'])
    ->middleware(['auth'])
    ->name('organizer.notifications.send');