<?php
// Función para crear una taxonomía
function crear_taxonomia_jerarquica() {

    // Definimos un array para las traducciones de la taxonomía
    $etiquetas = array(
        'name' => __( 'Categorías de proyectos' ),
        'singular_name' => __( 'Categoría de proyecto' ),
        'search_items' =>  __( 'Buscar categorías' ),
        'all_items' => __( 'Todos los categorías' ),
        'parent_item' => __( 'Categoría padre' ),
        'parent_item_colon' => __( 'Categoría padre:' ),
        'edit_item' => __( 'Editar categoría' ), 
        'update_item' => __( 'Actualizar categoría' ),
        'add_new_item' => __( 'Agregar una nueva categoría' ),
        'menu_name' => __( 'Categorías' ),
    ); 	


    // Función WordPress para registrar la taxonomía
    register_taxonomy(
        'categoria',
        array('proyectos'), // Tipos de Post a los que asociaremos la taxonomía
        array(
            'hierarchical' => true, // True para taxonomías del tipo "Categoría" y false para el tipo "Etiquetas"
            'labels' => $etiquetas, // La variable con las traducciones de las etiquetas
            'show_ui' => true,
            'show_admin_column' => true,
            'show_in_rest' => true, // This enables the REST API endpoint
            'query_var' => true,
            'rewrite' => array( 'slug' => 'categoria-proyecto' ),
        )
    );

}
add_action( 'init', 'crear_taxonomia_jerarquica', 0 );