$("#form-contacto").validate({
    rules: {
        asunto: "required",
        nombre: "required",
        correo: {
            required: true,
            email: true
        },
    },
    messages: {
        asunto: "El asunto es requerido",
        nombre: "El nombre completo es requerido",
        correo: {
            required: "El correo es requerido",
            email: "El correo es inválido"
        }
    },
    submitHandler: function (form, event) {
        event.preventDefault();
        sendFormularioContacto();
    },
});

function sendFormularioContacto(){
    var isvalid = $("#form-contacto").valid();
    var f = $('#form-contacto');
    var data = getFormData(f);
    if (isvalid) {
        $('#btnContact').removeClass('error');
        $('#btnContact').addClass('enviando');
        $('#btnContact span').text("Enviando...");
        $.ajax({
            url: aj_ajax.ajaxurl,
            type: 'post',
            data: {
                'action': 'actionCorreoContacto',
                formulario: data,
            },
            success: function (resp) {
                var resultado = JSON.parse(resp);
                if (resultado.code == "success") {
                    $('#btnContact').removeClass('enviando');
                    $('#btnContact span').text("Mensaje enviado!");
                    setTimeout(() => {
                        $('#btnContact span').text("Enviar");
                    }, 3000);
                    $("#form-contacto")[0].reset();
                } else {
                    $('#btnContact').removeClass('enviando');
                    $('#btnContact').addClass('error');
                    $('#btnContact span').text("Algo salio mal! no pudimos enviar tu mensaje.");
                }
            },
            error: function (jqXHR, estado, error) {
                $('#btnContact').removeClass('enviando');
                $('#btnContact').addClass('error');
                $('#btnContact span').text("Algo salio mal! no pudimos enviar tu mensaje.");
            },
            complete: function (jqXHR, estado) {
            }
        });
    }
}