<?php

# Hide Adminbar    
show_admin_bar(false);

# URL Template
function theme_url()
{
    return get_template_directory_uri();
}

# URL Blog
function blog_url()
{
    return bloginfo('url');
}

# Remove WP Version   
add_filter('the_generator', 'wpbeginner_remove_version');

function wpbeginner_remove_version()
{
    return '';
}

# Register Menu
add_action('init', 'register_menus');

function register_menus()
{
    register_nav_menus(array(
        'main-menu' => __('Menu Principal', 'Plantilla'),
    ));
}

# Add Thumbnails Support
add_theme_support('post-thumbnails');

# Add Feed Links Support
add_theme_support('automatic-feed-links');

/*
    * Switch default core markup for search form, comment form, and comments
    * to output valid HTML5.
    */
add_theme_support(
    'html5',
    array(
        'search-form',
        'comment-form',
        'comment-list',
        'gallery',
        'caption',
    )
);

# Enqueue Frontend Styles
add_action('wp_enqueue_scripts', 'load_css_frames');

function load_css_frames()
{
    //Swiper
    wp_enqueue_style('swiper-css', get_template_directory_uri() . "/assets/styles/css/swiper.css", array(), '', 'all');
    //Style Theme
    wp_enqueue_style('style', get_template_directory_uri() . "/assets/styles/sass/main.css", array(), '', 'all');
}

# Enqueue Frontend Styles
add_action('wp_enqueue_scripts', 'load_scripts_frames');

function load_scripts_frames()
{
    wp_enqueue_script('jquery-validate', get_template_directory_uri() . '/assets/js/jquery.validate.min.js', array(), '', 'jquery');
    wp_enqueue_script('additional-methods', get_template_directory_uri() . '/assets/js/additional-methods.js', array(), '', 'jquery');
    //Jquery
    wp_enqueue_script('jquery', get_template_directory_uri() . '/assets/js/libs/jquery.min.js', array(), '', 'all');
    //Swiper
    wp_enqueue_script('swiper-js', get_template_directory_uri() . '/assets/js/libs/swiper.js', array(), '', 'all');
    //GSAP
    wp_enqueue_script('gsap-js', get_template_directory_uri() . '/assets/js/gsap/gsap.min.js', array(), '', 'all');
    //DrawSVGPlugin
    wp_enqueue_script('DrawSVGPlugin-js', get_template_directory_uri() . '/assets/js/gsap/DrawSVGPlugin.min.js', array(), '', 'all');
    //Script Theme
    wp_enqueue_script('script', get_template_directory_uri() . "/assets/js/main.js", array(), '', 'all');
    //Send mail
    wp_enqueue_script('send-mail', get_template_directory_uri() . "/assets/js/sendMail.js", array(), '', 'all');
    wp_enqueue_script('woocommerceEventsBind', get_template_directory_uri() . "/assets/js/woocommerceEventsBind.js", array(), '', 'all');

    if (is_page_template('template-parts/page-inicio.php')) {
        wp_enqueue_script('inicio', get_template_directory_uri() . '/assets/js/inicioController.js', array(), '', 'all');
    }

    if (is_page_template('template-parts/page-acercaDe.php')) {
        wp_enqueue_script('acercaDe', get_template_directory_uri() . '/assets/js/acercaDeController.js', array(), '', 'all');
    }

    if (is_page_template('template-parts/page-todosDibujamos.php')) {
        wp_enqueue_script('todosDibujamos', get_template_directory_uri() . '/assets/js/sendMailTodosDibujamos.js', array(), '', 'all');
        wp_enqueue_script('todosDibujamosController', get_template_directory_uri() . '/assets/js/todosDibujamosController.js', array(), '', 'all');
    }

    if (is_page_template('template-parts/page-proyectos.php')) {
        wp_enqueue_script('proyectos', get_template_directory_uri() . '/assets/js/proyectosController.js', array(), '', 'all');
    }

    if (is_shop()) {
        wp_enqueue_script('productos', get_template_directory_uri() . '/assets/js/productosController.js', array(), '', 'all');
    }

    if ('product' == get_post_type()) {
        wp_enqueue_script('producto', get_template_directory_uri() . '/assets/js/productoController.js', array(), '', 'all');
    }

    if (is_single()) {
        wp_enqueue_script('proyecto', get_template_directory_uri() . "/assets/js/proyectoController.js", array(), '', 'all');
        //Animation Slides
        // wp_enqueue_script('animation-slideCasos.js',get_template_directory_uri() . "/assets/js/animation-slideCasos.js", array(), '', 'all');
    }

    wp_localize_script('script', 'aj_ajax', array(
        'ajaxurl' => admin_url('admin-ajax.php'),
        'aj_nonce' => wp_create_nonce('aj-nonce')
    ));
}

require_once(get_stylesheet_directory() . '/request/filtroTienda.php');
require_once(get_stylesheet_directory() . '/mailing/mail-contacto.php');
// require_once (get_stylesheet_directory() . '/mailing/mailTodosDibujamos.php');

function add_ajax_actions()
{
    //envio de correo
    add_action('wp_ajax_actionCorreoContacto', 'sendContacto');
    add_action('wp_ajax_nopriv_actionCorreoContacto', 'sendContacto');
    //envio de correo todos dibujamos
    add_action('wp_ajax_actionCorreoTodosDibujamos', 'sendTodosDibujamos');
    add_action('wp_ajax_nopriv_actionCorreoTodosDibujamos', 'sendTodosDibujamos');
    //filtroTienda
    add_action('wp_ajax_actionFiltroTienda', 'filtroTienda');
    add_action('wp_ajax_nopriv_actionFiltroTienda', 'filtroTienda');
}

add_action('admin_init', 'add_ajax_actions');

# Remove Welcome Widget from the Dashboard
add_action('wp_dashboard_setup', 'remove_dashboard_widgets');

function remove_dashboard_widgets()
{
    remove_meta_box('dashboard_quick_press', 'dashboard', 'side');
    remove_meta_box('dashboard_incoming_links', 'dashboard', 'normal');
    remove_meta_box('dashboard_right_now', 'dashboard', 'normal');
    remove_meta_box('dashboard_activity', 'dashboard', 'normal');
    remove_meta_box('dashboard_plugins', 'dashboard', 'normal');
    remove_meta_box('dashboard_recent_drafts', 'dashboard', 'normal');
    remove_meta_box('dashboard_recent_comments', 'dashboard', 'normal');
    remove_meta_box('dashboard_primary', 'dashboard', 'side');
    remove_meta_box('dashboard_secondary', 'dashboard', 'side');
}

remove_action('welcome_panel', 'wp_welcome_panel');

#SMK
include 'assets/inc/smk.php';

# Protect WordPress Against Malicious URL Requests Plugin
include_once(get_stylesheet_directory() . '/assets/inc/security.php');

// Define path and URL to the ACF plugin.
define('MY_ACF_PATH', get_stylesheet_directory() . '/assets/inc/plugins/acf/');
define('MY_ACF_URL', get_stylesheet_directory_uri() . '/assets/inc/plugins/acf/');

// Include the ACF plugin.
include_once(MY_ACF_PATH . 'acf.php');

// Customize the url setting to fix incorrect asset URLs.
add_filter('acf/settings/url', 'my_acf_settings_url');
function my_acf_settings_url($url)
{
    return MY_ACF_URL;
}

// Define path and URL to the ACF plugin.
define('MY_CANALLA_PATH', get_stylesheet_directory() . '/assets/inc/plugins/canalla/');
define('MY_CANALLA_URL', get_stylesheet_directory_uri() . '/assets/inc/plugins/canalla/');

// Include the ACF plugin.
include_once(MY_CANALLA_PATH . 'admin-ui.php');

// Customize the url setting to fix incorrect asset URLs.
add_filter('canalla/settings/url', 'my_canalla_settings_url');
function my_canalla_settings_url()
{
    return MY_CANALLA_URL;
}
#-------------------------------------------------------------------------------------------------------------------------#
#-----------------------------------     FUNCIONES CUSTOM BY CANALLA TI    -----------------------------------------------#
#-------------------------------------------------------------------------------------------------------------------------#

/**
 *	vince_check_active_menu()
 *
 *	Te indica en que pagina estas y agrega una clase llamada "is-active".
 *
 * @author Edgar Olivas Guzmán
 * @version 1.0
 * @category Menu
 * @return string 'is-active'
 * @date 25-09-2018
 */
function vince_check_active_menu($menu_item)
{
    $actual_link = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
    if ($actual_link == $menu_item->url) {
        return 'is-active';
    }
    return '';
}

/**
 *	the_slug()
 *
 *	Regresa el slug de la pagina en la que estas.
 *
 * @author Edgar Olivas Guzmán
 * @version 1.0
 * @category Tags, Posts
 * @return string $slug
 * @date 25-09-2018
 */
function the_slug($echo = true)
{
    $slug = basename(get_permalink());
    do_action('before_slug', $slug);
    $slug = apply_filters('slug_filter', $slug);
    if ($echo) echo $slug;
    do_action('after_slug', $slug);
    return $slug;
}

/**
 *	get_excerpt_custom()
 *
 *	Obtiene el except del post con un numero de caracteres limitados.
 *
 * @author Edgar Olivas Guzmán
 * @version 1.0
 * @category Tags, Posts
 * @return string $excerpt
 * @date 25-09-2018
 */
function get_excerpt_custom($val_size = 0, $id_post_custom = 0)
{
    $excerpt = get_the_content('', 0, $id_post_custom);
    $excerpt = preg_replace(" ([.*?])", '', $excerpt);
    $excerpt = strip_shortcodes($excerpt);
    $excerpt = strip_tags($excerpt);
    $excerpt = substr($excerpt, 0, $val_size);
    $excerpt = substr($excerpt, 0, strripos($excerpt, " "));
    return $excerpt;
}
function limitaCaracteres($num, $text)
{
    $result = substr($text, 0, $num);
    return $result;
}

/**
 *
 *	Quitar rol de administrador
 *
 * @author Edgar Olivas Guzmán
 * @version 1.0
 * @category Users
 * @date 18-07-2019
 */
add_action('editable_roles', 'hide_adminstrator_editable_roles');
function hide_adminstrator_editable_roles($roles)
{
    if (isset($roles['administrator']) && !current_user_can('level_10')) {
        unset($roles['administrator']);
    }
    return $roles;
}

/**
 *
 *	Corrección temporal de el error que tiene el editor Gutenberg
 *
 * @author Edgar Olivas Guzmán
 * @version 1.0
 * @category Gutenberg
 * @date 18-07-2019
 */
function gutenbergFix_enqueue()
{
    // Make sure you link this to your actual file.
    wp_register_style('gutenbergFix', get_template_directory_uri() . '/assets/styles/css/gutenbergFix.css');
    wp_enqueue_style('gutenbergFix');
}
add_action('enqueue_block_editor_assets', 'gutenbergFix_enqueue');


/* IMPORT OPTION PAGE */
require('assets/inc/acf/option-page/settings.php'); // Pagina de opciones

// IMPORT CPT
include 'assets/inc/cpt/proyectos.php';
include 'assets/inc/cpt/productosExternos.php';
//Import TAXONOMY
// include 'assets/inc/tax/categoriaProductos.php';
include 'assets/inc/tax/categoriaProyectos.php';

#---------------------------------------------------------------------------#
# Saving and synchronize ACF FILES                                                          #
#---------------------------------------------------------------------------# 

function my_acf_json_save_point($path)
{
    // update path
    $path = get_stylesheet_directory() . '/assets/inc/acfCustom/';

    // return
    return $path;
}

add_filter('acf/settings/save_json', 'my_acf_json_save_point');

function my_acf_json_load_point($paths)
{
    // remove original path (optional)
    unset($paths[0]);

    // append path
    $paths[] = get_stylesheet_directory() . '/assets/inc/acfCustom/';

    // return
    return $paths;
}
///////////////////////////////////////////////////////////////////////////////

add_filter('acf/settings/load_json', 'my_acf_json_load_point');

//Oculta elementos del menú///////////////////////////////////////////////////
function remove_menu_elements()
{

    $userData = wp_get_current_user();
    if ($userData->data->user_login != 'AdminTI') {
        //remove_menu_page( 'index.php' );                  //Dashboard
        remove_menu_page('edit.php');                   //Posts
        remove_menu_page('edit.php?post_type=acf-field-group');  //Custom fields
        // remove_menu_page( 'upload.php' );                 //Media
        //remove_menu_page( 'edit.php?post_type=page' );    //Pages
        remove_menu_page('edit-comments.php');          //Comments
        remove_menu_page('themes.php');                 //Appearance
        remove_menu_page('plugins.php');                //Plugins
        remove_menu_page('users.php');                  //Users
        remove_menu_page('tools.php');                  //Tools
        // remove_menu_page( 'profile.php' );                  //Profile
        remove_menu_page('options-general.php');        //Settings
        remove_menu_page('admin.php?page=wc-settings&tab=woo-variation-gallery'); //gallery settings
        remove_menu_page('admin.php?page=berocket_account'); //BeRocket
        remove_menu_page('admin.php?page=yith_wcwl_panel'); //YITH
        remove_menu_page('admin.php?page=monsterinsights_reports#'); //insights 
    }
}

add_action('admin_menu', 'remove_menu_elements');
////////////////////////////////////////////////////////////////////////////////
// Reordeno los menús en el panel de administración, para que se muestre fácil
function change_menu_order($menu_order)
{
    return array(
        'index.php',
        'edit.php?post_type=page',
        'edit.php?post_type=product',
        'edit.php?post_type=productosexternos',
        'edit.php?post_type=proyectos',
    );
}
add_filter('custom_menu_order', '__return_true');
add_filter('menu_order', 'change_menu_order');
////////////////////////////////////////////////////////////////////////////////

//Desabilita gutenberg
add_filter('use_block_editor_for_post_type', '__return_false', 100);

//Remueve elementos de post
add_action('init', 'remove_elements_support', 100);

function remove_elements_support()
{
    remove_post_type_support('post', 'editor');
    remove_post_type_support('page', 'editor');
    remove_post_type_support('proyectos', 'editor');
    remove_post_type_support('product', 'editor');
    // ‘title’
    // ‘editor’ (content)
    // ‘author’
    // ‘thumbnail’ (featured image) (current theme must also support Post Thumbnails)
    // ‘excerpt’
    // ‘trackbacks’
    // ‘custom-fields’
    // ‘comments’ (also will see comment count balloon on edit screen)
    // ‘revisions’ (will store revisions)
    // ‘page-attributes’ (template and menu order) (hierarchical must be true)
    // ‘post-formats’ removes post formats, see Post Formats
}

//Agrega ACF en rest api//////////////////////////////////////////////////////////////
function create_ACF_meta_in_REST()
{
    $postypes_to_exclude = ['acf-field-group', 'acf-field'];
    $extra_postypes_to_include = ["page"];
    $post_types = array_diff(get_post_types(["_builtin" => false], 'names'), $postypes_to_exclude);

    array_push($post_types, $extra_postypes_to_include);

    foreach ($post_types as $post_type) {
        register_rest_field(
            $post_type,
            'acf',
            [
                'get_callback'    => 'expose_ACF_fields',
                'schema'          => null,
            ]
        );
    }
}

function expose_ACF_fields($object)
{
    $ID = $object['id'];
    return get_fields($ID);
}

add_action('rest_api_init', 'create_ACF_meta_in_REST');
/////////////////////////////////////////////////////////////////////////////////////////

function imagenesAlt($alt, $description, $title)
{
    if ($alt) {
        return $alt;
    } else if ($description) {
        return $description;
    } else {
        return $title;
    }
}

/////////////////////////////////////////////////////
function telCorrect($tel)
{
    $tel = trim($tel);
    $tel = str_replace('(', '', $tel);
    $tel = str_replace(')', '', $tel);
    $tel = str_replace('-', '', $tel);
    $tel = str_replace(' ', '', $tel);
    return $tel;
}

function mytheme_add_woocommerce_support()
{
    add_theme_support('woocommerce');
}
add_action('after_setup_theme', 'mytheme_add_woocommerce_support');
//se remueven los estilos
add_filter('woocommerce_enqueue_styles', '__return_empty_array');

// remove_action( 'woocommerce_product_thumbnails', 'woocommerce_show_product_thumbnails', 20  );
// add_action( 'woocommerce_single_product_summary', 'woocommerce_show_product_images', 100 );
// add_action( 'woocommerce_single_product_summary', 'woocommerce_show_product_thumbnails', 100 );

//show attributes after summary in product single view
// add_action('woocommerce_single_product_summary', function() {
// 	//template for this is in storefront-child/woocommerce/single-product/product-attributes.php
// 	global $product;
// 	echo wc_display_product_attributes($product);
// }, 25);

// Display Select field before add to cart button
add_action('woocommerce_before_add_to_cart_button', 'sizes_before_add_to_cart_button', 0);
function sizes_before_add_to_cart_button()
{
    global $product;

    // Only on simple products
    if (! $product->is_type('simple')) return;

    // When product sizes are available
    if ($sizes = $product->get_attribute('talla')) :
        $sizes = explode(", ", $sizes);
        $sizeTitle = "Tallas";
        echo '<p class="title-select-single"><strong>' . $sizeTitle . ':</strong></p>
        <div class="contenedor-select mb32">
            <select name="product-talla">';
        foreach ($sizes as $size) {
            echo '<option value="' . $size . '">' . $size . '</option>';
        }
        echo   '</select>
          </div>';
    endif;
}


add_filter('woocommerce_add_cart_item_data', 'add_size_to_cart_item_data', 10, 3);
function add_size_to_cart_item_data($cart_item_data, $product_id, $variation_id)
{
    if (isset($_POST['product-talla'])) {
        $cart_item_data['product-talla'] = esc_attr($_POST['product-talla']);
    }
    return $cart_item_data;
}

add_filter('woocommerce_get_item_data', 'display_size_on_cart_item', 10, 2);
function display_size_on_cart_item($cart_item_data, $cart_item)
{
    if (isset($cart_item['product-talla'])) {
        $cart_item_data[] = array(
            'name' => __('Talla'),
            'value' => $cart_item['product-talla'],
        );
    }
    return $cart_item_data;
}

add_action('woocommerce_checkout_create_order_line_item', 'save_order_item_product_fitting_color', 10, 4);
function save_order_item_product_fitting_color($item, $cart_item_key, $cart_item, $order)
{
    if (isset($cart_item['product-talla'])) {
        $item->update_meta_data('Talla', $cart_item['product-talla']);
    }
}